% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_all_with_p.R
\name{tw_get_all_with_p}
\alias{tw_get_all_with_p}
\title{Get all items that have a given property (irrespective of the value)}
\usage{
tw_get_all_with_p(
  p,
  fields = c("item", "itemLabel", "itemDescription"),
  language = tidywikidatar::tw_get_language(),
  method = "SPARQL",
  wait = 0.1,
  limit = Inf,
  return_as_tw_search = TRUE,
  user_agent = tidywikidatar::tw_get_user_agent()
)
}
\arguments{
\item{p}{A character vector, a property. Must always start with the capital
letter "P", e.g. "P31" for "instance of".}

\item{fields}{A character vector of Wikidata fields. Ignored if
\code{return_as_tw_search} is set to \code{TRUE} (as per default). Defaults to
\verb{("item", "itemLabel", "itemDescription")}}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". If more than one, can be set in order of preference, e.g.
\code{c("it", "fr", "en")}. Use "all_available" to keep all languages. For
available language values, see the
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{list
of available language codes in the official documentation}.}

\item{method}{Defaults to "SPARQL". The only accepted alternative value is
"JSON", to use instead json-based API.}

\item{wait}{Defaults to 0.1. Used only in method is set to "JSON".}

\item{limit}{Defaults to \code{Inf}. Set to smaller values for testing and cache
locally when possible to reduce load on servers.}

\item{return_as_tw_search}{Logical, defaults to \code{TRUE}. If \code{TRUE}, returns a
data frame with three columns (\code{id}, \code{label}, and \code{description}) that can
be piped to other \code{tw_} functions. If \code{FALSE}, a data frame with as many
columns as fields.}

\item{user_agent}{Defaults to a combination of \code{tidywikidatar} and package
version number. Consider customising it for the current sessions with
\code{\link[=tw_set_user_agent]{tw_set_user_agent()}}, in particular if you are making many queries.}
}
\value{
A data frame with three columns is method is set to "SPARQL", or as
many columns as fields if more are given and \code{return_as_tw_search} is set
to \code{FALSE}. A single column with Wikidata identifier if method is set to
"JSON".
}
\description{
This function does not cache results.
}
\examples{
if (interactive()) {
  # get all Wikidata items with an ICAO airport code ("P239")
  tw_get_all_with_p(p = "P239", limit = 10)
}
}
