% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{get_time_resolution}
\alias{get_time_resolution}
\title{Return the time resolution of a datetime sequence}
\usage{
get_time_resolution(dttm_seq, units = "mins")
}
\arguments{
\item{dttm_seq}{datetime sequence}

\item{units}{character being one of "auto", "secs", "mins", "hours", "days" and "weeks"}
}
\value{
numeric
}
\description{
Return the time resolution of a datetime sequence
}
\examples{
seq_15m <- as.POSIXct(
  c("2024-01-01 00:00:00", "2024-01-01 00:15:00", "2024-01-01 00:30:00"),
  tz = "UTC"
)
get_time_resolution(seq_15m, units = "mins")

}
