% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vector.R
\name{format_vector}
\alias{format_vector}
\title{Format a Vector}
\usage{
format_vector(
  x,
  output = "html",
  digits = NULL,
  num_fmt = "significant",
  num_zero = FALSE,
  num_suffix = FALSE,
  num_mark_big = "",
  num_mark_dec = getOption("OutDec", default = "."),
  date = NULL,
  bool = NULL,
  math = FALSE,
  other = NULL,
  replace = FALSE,
  escape = FALSE,
  markdown = FALSE,
  quarto = FALSE,
  fn = NULL,
  sprintf = NULL,
  linebreak = NULL
)
}
\arguments{
\item{x}{A vector to be formatted.}

\item{output}{Output format. One of "html", "latex", "typst", "markdown", etc.}

\item{digits}{Number of significant digits or decimal places.}

\item{num_fmt}{The format for numeric values; one of 'significant', 'significant_cell', 'decimal', or 'scientific'.}

\item{num_zero}{Logical; if TRUE, trailing zeros are kept in "decimal" format (but not in "significant" format).}

\item{num_suffix}{Logical; if TRUE display short numbers with \code{digits} significant digits and K (thousands), M (millions), B (billions), or T (trillions) suffixes.}

\item{num_mark_big}{Character to use as a thousands separator.}

\item{num_mark_dec}{Decimal mark character. Default is the global option 'OutDec'.}

\item{date}{A string passed to the \code{format()} function, such as "\%Y-\%m-\%d". See the "Details" section in \code{?strptime}}

\item{bool}{A function to format logical columns. Defaults to title case.}

\item{math}{Logical. If TRUE, wrap cell values in math mode \verb{$..$}. This is useful for LaTeX output or with HTML MathJax \code{options(tinytable_html_mathjax=TRUE)}.}

\item{other}{A function to format columns of other types. Defaults to \code{as.character()}.}

\item{replace}{Logical, String or Named list of vectors
\itemize{
\item TRUE: Replace \code{NA} and \code{NaN} by an empty string.
\item FALSE: Print \code{NA} and \code{NaN} as strings.
\item String: Replace \code{NA} and \code{NaN} entries by the user-supplied string.
\item Named list: Replace matching elements of the vectors in the list by theirs names. Example:
\itemize{
\item \code{list("-" = c(NA, NaN), "Tiny" = -Inf, "Massive" = Inf)}
}
}}

\item{escape}{Logical or "latex" or "html". If TRUE, escape special characters to display them as text in the format of the output of a \code{tt()} table.
\itemize{
\item If \code{i} and \code{j} are both \code{NULL}, escape all cells, column names, caption, notes, and spanning labels created by \code{group_tt()}.
}}

\item{markdown}{Logical; if TRUE, render markdown syntax in cells. Ex: \verb{_italicized text_} is properly italicized in HTML and LaTeX.}

\item{quarto}{Logical. Enable Quarto data processing and wrap cell content in a \code{data-qmd} span (HTML) or \verb{\\QuartoMarkdownBase64\{\}} macro (LaTeX). See warnings in the Global Options section below.}

\item{fn}{Function for custom formatting. Accepts a vector and returns a character vector of the same length.}

\item{sprintf}{String passed to the \code{?sprintf} function to format numbers or interpolate strings with a user-defined pattern (similar to the \code{glue} package, but using Base R).}

\item{linebreak}{NULL or a single string. If it is a string, replaces that string with appropriate line break sequences depending on the output format (HTML: \verb{<br>}, LaTeX: \verb{\\\\\\\\}, Typst: \verb{\\\\ }). Markdown output is excluded from line break replacement.}
}
\value{
A character vector with formatted values.
}
\description{
Format a Vector
}
\details{
This function formats a vector by passing it to \code{format_tt()}. All formatting arguments must be of length 1 or \code{length(x)}.
}
\examples{
# Format numeric vector
format_vector(c(1234.567, 9876.543), digits = 2, num_mark_big = ",")

# Format dates
dates <- as.Date(c("2023-01-01", "2023-12-31"))
format_vector(dates, date = "\%B \%d, \%Y")

# Format logical values
format_vector(c(TRUE, FALSE, TRUE), bool = function(x) ifelse(x, "Yes", "No"))
}
