% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pali-sort.R
\name{pali_sort}
\alias{pali_sort}
\title{Sorting function for vectors of Pali words.}
\usage{
pali_sort(word_list)
}
\arguments{
\item{word_list}{A vector of Pali words}
}
\value{
A new vector of Pali words in Pali alphabetical order
}
\description{
Note that all Pali string comparisons are case-insensitive.
This algorithm is based on Quicksort, but creates lots of
intermediate data structures instead of doing swaps in place.
This has been implemented in C++ as the original R version
was about 500x slower.
}
\examples{
\donttest{
# A sorted list of 100 random words from the Tipitaka:
pali_sort(sample(tipitaka_long$word, 100))
}
}
