% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_components}
\alias{tm_components}
\title{Group components}
\usage{
tm_components(
  group_id = "",
  position,
  stack,
  frame_combine,
  equalize,
  resize_as_group,
  stack_margin,
  offset,
  frame,
  frame.color,
  frame.alpha,
  frame.lwd,
  frame.r,
  bg,
  bg.color,
  bg.alpha
)
}
\arguments{
\item{group_id}{id of the component group. By default set to \code{""}, which will apply to all components. There are two other options. 1) To use the same (self-chosen) name that corresponds to the \code{group_id} argument of a component function, such as \code{\link[=tm_legend]{tm_legend()}} and \code{\link[=tm_title]{tm_title()}}. 2) To specify one (or more) component function names, e.g. \code{"tm_legend"} or \code{c("tm_scalebar", "tm_compass")}.}

\item{position}{The position specification of the components in this group: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}.}

\item{stack}{stacking \code{"horizontal"} or \code{"vertical"}}

\item{frame_combine}{put frame around all components that are drawn on the same location. Whether a frame is drawn is still decided by the \code{frame} argument of the  'main' (first) component.}

\item{equalize}{in case \code{frame_combine} is \code{FALSE}, should the separate frames be equalized, i.e. have the same width (when stacked vertically) or height (when stacked horizontally)?}

\item{resize_as_group}{in case a component if rescaled because of the limited space, rescale the other components proportionally?}

\item{stack_margin}{Margin between components}

\item{offset}{Offset margin between frame and the components block}

\item{frame}{Should a frame be drawn? By default \code{TRUE} for legends, charts and insets, and \code{FALSE} otherwise.}

\item{frame.color}{frame color}

\item{frame.alpha}{frame alpha transparancy}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg}{Background color the components block. Is usually set in each component function, but if specified here, it will overwrite them.}

\item{bg.color}{Background color the components block. Is usually set in each component function, but if specified here, it will overwrite them.}

\item{bg.alpha}{Background alpha transparency of the components block. Is usually set in each component function, but if specified here, it will overwrite them.}
}
\value{
A \code{\link{tmap-element}}
}
\description{
Group components
}
