% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_crs.R
\name{tm_crs}
\alias{tm_crs}
\title{Set the map projection (CRS)}
\usage{
tm_crs(crs = NA, property = NA, bbox = NULL)
}
\arguments{
\item{crs}{Map projection (CRS). Can be set to an \code{crs} object (see \code{\link[sf:st_crs]{sf::st_crs()}}), a proj4string, an EPSG number, the value \code{"auto"} (automatic crs recommendation), or one the the following generic projections: \code{c("laea", "aeqd", "utm", "pconic", "eqdc", "stere")}. See details.}

\item{property}{Which property should the projection have? One of: \code{"global"}, \code{"area"} (equal-area), \code{"distance"} (equidistant), \code{"shape"} (conformal). Only applicable if \code{crs = "auto"}. See details.}

\item{bbox}{bounding box. Three options: a \code{\link[sf:st_bbox]{sf::st_bbox()}} object, an Open Street Map query (passed on to \code{\link[tmaptools:geocode_OSM]{tmaptools::geocode_OSM()}}), or \code{"FULL"}, which means the whole earth , which means the whole earth (this also guarantees that transformations to another CRS keep the whole earth, unlike \code{\link[sf:st_bbox]{sf::st_bbox()}}).}
}
\description{
This function sets the map projection. It can also be set via \code{\link[=tm_shape]{tm_shape()}}, but \code{tm_crs} is generally recommended for most cases. It can also be determined automatically (see details); however, this is still work-in-progress.
}
\details{
The map projection (\code{crs}) determines in which coordinate system the spatial object is processed and plotted.
See \href{https://r-tmap.github.io/tmap/articles/foundations_crs}{vignette about CRS}. The \code{crs} can be specified in two places: 1) \code{tm_shape()} and \code{tm_crs()}.
In both cases, the map is plotted into the specified \code{crs}. The difference is that in the first option, the \code{crs} is also taken into account in spatial transformation functions, such as the calculation of centroids and cartograms. In the second option, the \code{crs} is only used in the plotting phase.

The automatic crs recommendation (which is still work-in-progress) is the following:\tabular{ll}{
   \strong{Property} \tab \strong{Recommendation} \cr
   \code{global} (for world maps) \tab A pseudocylindrical projection tmap option \code{crs_global}, by default \verb{"eqearth} (Equal Earth). See \url{https://r-tmap.github.io/tmap/articles/41_advanced_crs.html} for more options \cr
   \code{area} (equal area) \tab Lambert Azimuthal Equal Area (\code{laea}) \cr
   \code{distance}	(equidistant) \tab Azimuthal Equidistant (\code{aeqd}) \cr
   \code{shape}	(conformal) \tab Stereographic (\code{stere}) \cr
}


For further info about the available "generic" projects see:
for utm: \url{https://proj.org/en/9.4/operations/projections/utm.html}
for laea: \url{https://proj.org/en/9.4/operations/projections/laea.html}
for aeqd: \url{https://proj.org/en/9.4/operations/projections/aeqd.html}
for pconic: \url{https://proj.org/en/9.4/operations/projections/pconic.html}
for eqdc: \url{https://proj.org/en/9.4/operations/projections/eqdc.html}
}
\note{
Plans are to migrate the functionality regarding generic crs and automatic crs recommendation to a separate package.
}
\examples{
SA = World[World$continent == "South America", ]

# latlon coordinates (WGS84)
tm_shape(SA) +
	tm_polygons() +
	tm_graticules() +
	tm_crs(4326)

tm_list = lapply(c("global", "area", "distance", "shape"), FUN = function(property) {
	tm_shape(SA) +
		tm_polygons() +
		tm_graticules() +
		tm_crs(property = property)	+
	tm_title(property)
})

tmap_arrange(tm_list, nrow = 1)
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/foundations_crs}{vignette about CRS}
}
