% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_export.R
\name{tmap_leaflet}
\alias{tmap_leaflet}
\alias{tmap_grob}
\title{Export tmap to the format of the used graphics mode}
\usage{
tmap_leaflet(x, show = FALSE, ...)

tmap_grob(x, asp = NA, scale = 1, show = FALSE, ...)
}
\arguments{
\item{x}{a tmap object.}

\item{show}{show the map?}

\item{...}{
  Arguments passed on to \code{\link[=print.tmap]{print.tmap}}
  \describe{
    \item{\code{return.asp}}{should the aspect ratio be returned?}
    \item{\code{vp}}{viewport (for \code{"plot"} mode)}
    \item{\code{knit}}{A logical, should knit?}
    \item{\code{in.shiny}}{A logical, is the map drawn in \strong{shiny}?}
    \item{\code{proxy}}{A logical, if \code{in.shiny}, is \code{\link[=tmapProxy]{tmapProxy()}} used?}
    \item{\code{options}}{A vector of options}
  }}

\item{asp, scale}{the desired aspect ratio and scale of the map. Only applicable for \code{"plot"} mode.}
}
\value{
\itemize{
\item \code{tmap_grob()} returns a \code{\link[grid:grid.grob]{grob}} object (\code{"plot"} mode)
\item \code{tmap_leaflet()} a \code{\link[leaflet:leaflet]{leaflet}} object (\code{"view"} mode).
In case small multiples are shown, a list is returned.
}
}
\description{
\itemize{
\item \code{tmap_grob()} returns a \code{\link[grid:grid.grob]{grob}} object (\verb{"plot" mode})
\item \code{tmap_leaflet()} a \code{\link[leaflet:leaflet]{leaflet}} object (\code{"view"} mode).
}
}
\examples{
map = tm_shape(World) + tm_polygons()
tmap_leaflet(map, show = TRUE)
}
