% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-coco.R
\name{coco_detection_dataset}
\alias{coco_detection_dataset}
\title{COCO Detection Dataset}
\usage{
coco_detection_dataset(
  root = tempdir(),
  train = TRUE,
  year = c("2017", "2014"),
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{root}{Root directory where the dataset is stored or will be downloaded to.}

\item{train}{Logical. If TRUE, loads the training split; otherwise, loads the validation split.}

\item{year}{Character. Dataset version year. One of \code{"2014"} or \code{"2017"}.}

\item{download}{Logical. If TRUE, downloads the dataset if it's not already present in the \code{root} directory.}

\item{transform}{Optional transform function applied to the image.}

\item{target_transform}{Optional transform function applied to the target (labels, boxes, etc.).}
}
\value{
An object of class \code{coco_detection_dataset}. Each item is a list:
\itemize{
\item \code{x}: a \verb{(C, H, W)} array representing the image.
\item \code{y$boxes}: a \verb{(N, 4)} \code{torch_tensor} of bounding boxes in the format  \eqn{(x_{min}, y_{min}, x_{max}, y_{max})}.
\item \code{y$labels}: an integer \code{torch_tensor} with the class label for each object.
\item \code{y$area}: a float \code{torch_tensor} indicating the area of each object.
\item \code{y$iscrowd}: a boolean \code{torch_tensor}, where \code{TRUE} marks the object as part of a crowd.
\item \code{y$segmentation}: a list of segmentation polygons for each object.
\item \code{y$masks}: a \verb{(N, H, W)} boolean \code{torch_tensor} containing binary segmentation masks.
}

The returned object has S3 classes \code{"image_with_bounding_box"} and \code{"image_with_segmentation_mask"}
to enable automatic dispatch by visualization functions such as \code{draw_bounding_boxes()} and \code{draw_segmentation_masks()}.
}
\description{
Loads the MS COCO dataset for object detection and segmentation.
}
\details{
The returned image is in CHW format (channels, height, width), matching the torch convention.
The dataset \code{y} offers object detection annotations such as bounding boxes, labels,
areas, crowd indicators, and segmentation masks from the official COCO annotations.
}
\examples{
\dontrun{
ds <- coco_detection_dataset(
  train = FALSE,
  year = "2017",
  download = TRUE
)

item <- ds[1]

# Visualize bounding boxes
boxed <- draw_bounding_boxes(item)
tensor_image_browse(boxed)

# Visualize segmentation masks (if present)
masked <- draw_segmentation_masks(item)
tensor_image_browse(masked)
}
}
\seealso{
Other detection_dataset: 
\code{\link{pascal_voc_datasets}},
\code{\link{rf100_biology_collection}()},
\code{\link{rf100_damage_collection}()},
\code{\link{rf100_document_collection}()},
\code{\link{rf100_infrared_collection}()},
\code{\link{rf100_medical_collection}()},
\code{\link{rf100_underwater_collection}()}
}
\concept{detection_dataset}
