% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_scheme.R
\name{asDiffusionScheme}
\alias{asDiffusionScheme}
\alias{asDiffusionScheme.matrix}
\alias{asDiffusionScheme.MriImage}
\alias{asDiffusionScheme.DiffusionScheme}
\title{Create a DiffusionScheme object from data}
\usage{
asDiffusionScheme(x, ...)

\method{asDiffusionScheme}{matrix}(x, bValues, ...)

\method{asDiffusionScheme}{MriImage}(x, ...)

\method{asDiffusionScheme}{DiffusionScheme}(x, ...)
}
\arguments{
\item{x}{An object to coerce to a \code{DiffusionScheme}.}

\item{...}{Additional arguments to methods.}

\item{bValues}{A vector of b-values, required when \code{x} is a matrix of
gradient directions.}
}
\value{
A \code{DiffusionScheme} object.
}
\description{
This is a generic function that converts another object to a
\code{DiffusionScheme} by extracting the relevant information. There are
methods for matrices (of gradient directions) and \code{MriImage} objects.
An image passed as an argument to the latter must have the \code{bValues}
and \code{bVectors} tags set appropriately.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
