% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{pluralise}
\alias{pluralise}
\title{Number agreement with a vector}
\usage{
pluralise(singular, x = NULL, n = NULL, plural = NULL)
}
\arguments{
\item{singular}{The singular form of the word.}

\item{x}{A vector of any mode, whose length is used to choose the correct
word form, unless \code{n} is specified.}

\item{n}{An integer which is used to choose the correct word form (singular
if n = 1, plural otherwise). Take priority over \code{x} if not
\code{NULL}.}

\item{plural}{The plural form of the word. If \code{NULL}, an 's' is simply
appended to the singular form.}
}
\value{
Either \code{singular} or \code{plural}, as appropriate.
}
\description{
This function chooses the singular or plural form of a word based on the
length of an associated vector, or an integer.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
