% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_scheme.R
\name{readDiffusionScheme}
\alias{readDiffusionScheme}
\alias{writeDiffusionScheme}
\title{Read and write diffusion schemes}
\usage{
readDiffusionScheme(fileName, bValues = NULL, imagePath = NULL, ...)

writeDiffusionScheme(scheme, fileName)
}
\arguments{
\item{fileName}{A string specifying a file name or stem.}

\item{bValues}{A numeric vector of b-values, or a single string naming a
file containing them (in a format readable by \code{\link{read.table}}).
The default is \code{NULL}, meaning that they should be read from the
\code{fileName} or a sidecar "bval" file.}

\item{imagePath}{An optional string giving the path to an image. If fewer
b-values are given than the number of gradient directions in the file,
the image will be read and passed to \code{\link{fillShells}} to fill in
the gaps. This is a convenience feature, but is heuristic-based and so
may not always be reliable.}

\item{...}{Further arguments to the \code{\linkS4class{DiffusionScheme}}
constructor, to adjust how shells are interpreted.}

\item{scheme}{A \code{\linkS4class{DiffusionScheme}} object to write to
file.}
}
\value{
\code{readDiffusionScheme} returns a \code{DiffusionScheme} object,
  or \code{NULL} if one cannot be read. \code{writeDiffusionScheme} is
  called for its side effect.
}
\description{
These functions read diffusion acquisition scheme objects from, and write
them to, text-based matrix files. They can handle both FSL-style (two-file)
and TractoR-style (single file) formats; in the two-file case either file
name can be specified.
}
\details{
Three main naming conventions for these files are recognised. TractoR's
preferred format is a single file with a ".dirs" extension, with the 
direction information stored one volume per row and b-values in the final
column. FSL uses files called "bvecs" and "bvals", with values stored one
volume per column; if the specified basic file name is exactly one of these
two then this format is assumed. BIDS uses the same format, but in files
named for the associated image with ".bvec" and ".bval" extensions. Any
other naming convention can be forced when writing by wrapping the file
name in a call to \code{\link{I}}, the "as-is" function.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
