% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rag_json.R
\name{parse_rag_json}
\alias{parse_rag_json}
\title{Parse RAG JSON}
\usage{
parse_rag_json(x, validate = TRUE)
}
\arguments{
\item{x}{JSON string or list.}

\item{validate}{Logical; validate structure after parse.}
}
\value{
A normalized list with atomic vectors and an `evidence` data.frame.
}
\description{
Parses a JSON string (or list) matching the enforced RAG schema and returns
a normalized list: `list(labels=chr, confidences=num, intensity=num,
evidence=data.frame(doc_id, span, score))`.
}
\examples{
j <- '{"labels":["joy"],"confidences":[0.9],
  "intensity":0.8,"evidence_chunks":[]}'
parse_rag_json(j)
}
