% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video_scores.R
\name{video_scores}
\alias{video_scores}
\title{Run FER on a YouTube video using a Hugging Face CLIP model}
\usage{
video_scores(
  video,
  classes,
  nframes = 100,
  face_selection = "largest",
  start = 0,
  end = -1,
  uniform = FALSE,
  ffreq = 15,
  save_video = FALSE,
  save_frames = FALSE,
  save_dir = "temp/",
  video_name = "temp",
  model = "oai-base",
  local_model_path = NULL
)
}
\arguments{
\item{video}{The URL of the YouTube video to analyze.}

\item{classes}{A character vector specifying the classes to analyze.}

\item{nframes}{The number of frames to analyze in the video. Default is 100.}

\item{face_selection}{The method for selecting faces in the video. Options are
"largest", "left", "right", or "none". Default is "largest". Use "none"
to classify the whole frame without face cropping.}

\item{start}{The start time of the video range to analyze. Default is 0.}

\item{end}{The end time of the video range to analyze. Default is -1 and this means that video won't be cut. If end is a positive number greater than start, the video will be cut from start to end.}

\item{uniform}{Logical indicating whether to uniformly sample frames from the video. Default is FALSE.}

\item{ffreq}{The frame frequency for sampling frames from the video. Default is 15.}

\item{save_video}{Logical indicating whether to save the analyzed video. Default is FALSE.}

\item{save_frames}{Logical indicating whether to save the analyzed frames. Default is FALSE.}

\item{save_dir}{The directory to save the analyzed frames. Default is "temp/".}

\item{video_name}{The name of the analyzed video. Default is "temp".}

\item{model}{A string specifying the vision model to use. Options include:
\itemize{
  \item Built-in models: "oai-base" (default), "oai-large", "eva-8B", "jina-v2"
  \item Any valid HuggingFace model ID
  \item Custom registered models (see \code{\link{register_vision_model}})
}
Use \code{\link{list_vision_models}} to see all available models.
Note: Video processing is memory-intensive, so use caution with large models.}

\item{local_model_path}{Optional. Path to a local directory containing a pre-downloaded
  HuggingFace model. If provided, the model will be loaded from this directory instead
  of being downloaded from HuggingFace. This is useful for offline usage or for using
  custom fine-tuned models.

  On Linux/Mac, look in ~/.cache/huggingface/hub/ folder for downloaded models.
  Navigate to the snapshots folder for the relevant model and point to the directory
  which contains the config.json file. For example:
  "/home/username/.cache/huggingface/hub/models--cross-encoder--nli-distilroberta-base/snapshots/b5b020e8117e1ddc6a0c7ed0fd22c0e679edf0fa/"

  On Windows, the base path is C:\\Users\\USERNAME\\.cache\\huggingface\\transformers\\

  Warning: Using very large models from local paths may cause memory issues or crashes
  depending on your system's resources, especially when processing videos with many frames.}
}
\value{
A result object containing the analyzed video scores.
}
\description{
This function retrieves facial expression recognition (FER) scores from a specific number of frames extracted from a YouTube video using a specified Hugging Face CLIP model. It utilizes Python libraries for facial recognition and emotion detection in text, images, and video.
}
\section{Data Privacy}{

  All processing is done locally with the downloaded model,
  and your video frames are never sent to any remote server or third-party.
}

\author{
Aleksandar Tomasevic <atomashevic@gmail.com>
}
