% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_choice.R
\name{validate_choice}
\alias{validate_choice}
\title{Validate Choice}
\usage{
validate_choice(
  input,
  choices,
  several.ok = FALSE,
  type = c("error", "warning", "message"),
  na_ok = TRUE,
  null_ok = TRUE,
  var_name = NULL,
  calls = NULL
)
}
\arguments{
\item{input}{The data to be validated.}

\item{choices}{a character vector of candidate values, often missing, see
documentation for \code{base::match.arg()} for more information.}

\item{several.ok}{logical specifying if \code{arg} should be allowed
    to have more than one element.}

\item{type}{A character string specifying the type of message to be displayed
if the input is not numeric or if the values are out of range. Must be one
of "error", "warning", or "message".}

\item{na_ok}{Logical. If TRUE, NA values are allowed. Default is TRUE.}

\item{null_ok}{Logical. If TRUE, NULL values are allowed. Default is TRUE.}

\item{var_name}{Optional. A character string giving the desired variable (or
object) name that will appear in console output in place of the how the
object will typically be named in messages via deparse(substitute(input)).}

\item{calls}{Optional. The number of callers to go back in the call stack for
error messaging. If NULL, will default to 2.}
}
\value{
The validated input if it is valid.
}
\description{
This function checks if an input is within a specified set of valid choices.
Depending on the specified type, it will either throw an error, issue a
warning, or send a message.
}
\details{
This function uses \code{\link[base]{match.arg}} to validate the input
against the allowed choices. Please see the documentation for
\code{\link[base]{match.arg}} for more details about how matching is
performed.
}
\author{
Nicolas Foss, Ed.D., MS
}
