% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeEnum.R
\name{enum2depthwise}
\alias{enum2depthwise}
\alias{enum2cladewise}
\alias{enum2_1toV}
\title{Change the node enumeration of trees in phylo(3D) format}
\usage{
enum2depthwise(tree)

enum2cladewise(tree)

enum2_1toV(tree_bad_enum)
}
\arguments{
\item{tree}{A rooted tree in (extended) phylo(3D) format
(no special node enumeration required, except that nodes are numbered
from 1 to |V| = the total number of nodes). There must be at least 2 nodes,
i.e. one edge.}

\item{tree_bad_enum}{A rooted tree in a a rough phylo(3D) format
(no special node enumeration required). There must be at least 2 nodes,
i.e. one edge.}
}
\value{
\code{enum2depthwise(tree)} Tree in (extended) phylo(3D) format as
before but with node enumeration conforming to the phylo format standard.

\code{enum2cladewise(tree)} Tree in (extended) phylo(3D) format as
before but with node enumeration conforming to the phylo format standard.

\code{enum2_1toV(tree)} Tree in format as before but with nodes
enumerated from 1 to |V|.
}
\description{
\code{enum2depthwise} - Changes the enumeration of the nodes of a tree to
a depthwise (top-down) enumeration that complies with the phylo format's
requirements. \cr
The input tree must have its nodes enumerated with 1,...,|V|
(with |V| being the total number of nodes).
\code{enum2depthwise} changes the node enumeration s.t. it fulfills the
other enumeration requirements of the phylo format like:\cr
- leaves are enumerated with 1,...,n, (with n being the number of leaves)\cr
- the root has number n+1, \cr
- and the rule for inner nodes: descendants have higher numbers than
their ancestors. \cr
The edge enumeration and order remains untouched.
The function works for phylo as well as phylo3D objects and possible
extensions like 'node.ancs', 'node.descs', etc. remain intact.

\code{enum2cladewise} - Changes the enumeration of the nodes of a tree to
a cladewise enumeration (i.e. starting from the root we follow the rule:
Go to left child; if that doesn't exist or was already visited go to the
right child) that complies with the phylo format's
requirements.\cr
The input tree must have its nodes enumerated with 1,...,|V|
(with |V| being the total number of nodes).
\code{enum2depthwise} changes the node enumeration s.t. it fulfills the
other enumeration requirements of the phylo format like:\cr
- leaves are enumerated with 1,...,n, (with n being the number of leaves)\cr
- the root has number n+1, \cr
- and the rule for inner nodes: descendants have higher numbers than
their ancestors. \cr
The edge enumeration and order remains untouched.
The function works for phylo as well as phylo3D objects and possible
extensions like 'node.ancs', 'node.descs', etc. remain intact.

\code{enum2_1toV} - Changes the enumeration of the nodes of a tree such that
they are enumerated with 1,...,|V| (with |V| being the total number of
nodes). Then \code{enum2cladewise} or \code{enum2depthwise} can be used to
switch to a specific enumeration. The edge enumeration and order remains
untouched.\cr
The input tree must have its nodes enumerated, i.e. the 'edge' attribute
must be a numeric matrix (with no missing values). Note that the attribute
'node.coords' is allowed, but then the old node enumeration must point to
the correct coordinates. All other rows of the coordinate matrix will be
ignored and deleted.
}
\examples{
tree <- treeDbalance::example3Dtrees$bean21
# Visualize enumeration: plotPhylo3D(tree, show_node_enum = TRUE)
tree_depthwise <- enum2depthwise(tree)
# Visualize: addPhylo3D(tree_depthwise, offset=c(2,0,0), show_node_enum = TRUE)
tree_cladewise <- enum2cladewise(tree)
# Visualize: addPhylo3D(tree_cladewise, offset=c(4,0,0), show_node_enum = TRUE)
bad_tree <- list(
  edge = matrix(c(1, 13, 1, -7, 13, 4), byrow = TRUE, ncol = 2),
  tip.label = c("", ""), Nnode = 2
)
better_tree <- enum2_1toV(bad_tree)
better_tree$edge
bad_3Dtree <- list(
  edge = matrix(c(1, 2, 1, 5, 2, 4), byrow = TRUE, ncol = 2),
  tip.label = c("", ""), Nnode = 2,
  node.coord = matrix(c(
    1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
    5, 5, 5, 6, 6, 6
  ), byrow = TRUE, ncol = 3),
  edge.weight = c(1, 1, 1)
)
better_3Dtree <- enum2_1toV(bad_3Dtree)
better_3Dtree$edge
better_3Dtree$node.coord
}
\author{
Sophie Kersting
}
