% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-headers.R
\name{parse_header_text}
\alias{parse_header_text}
\title{Convert character content of a header file into a tree-sitter root}
\usage{
parse_header_text(text, lang = language())
}
\arguments{
\item{text}{Character scalar with the header content to parse.}

\item{lang}{tree-sitter language object (default: C language from package)}
}
\value{
The tree root node object
}
\description{
Convert character content of a header file into a tree-sitter root
}
\examples{
if (requireNamespace("treesitter", quietly = TRUE)) {
  root <- parse_header_text("int foo(int);\n")
  root
}
}
