% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rate_diff_arima_ready.R
\encoding{UTF-8}
\name{check_rate_diff_arima_ready}
\alias{check_rate_diff_arima_ready}
\title{Assess Time Series Readiness for ARIMA Modeling / Pruefung der Eignung fuer ARIMA-Zeitreihenmodellierung}
\usage{
check_rate_diff_arima_ready(
  rate_diff_vec,
  date_vec = NULL,
  frequency = 52,
  plot_acf = TRUE,
  do_stl = TRUE,
  verbose = TRUE,
  max_lag_acf = min(3 * frequency, floor(length(rate_diff_vec)/4))
)
}
\arguments{
\item{rate_diff_vec}{Numeric vector of rate differences. / Numerischer Vektor (z.B. Rate)}

\item{date_vec}{Optional. Corresponding date vector (used for plotting). / Optionaler Datumsvektor}

\item{frequency}{Time series frequency (e.g., 52 for weekly). Default is 52. / Frequenz der Zeitreihe}

\item{plot_acf}{Logical. Whether to compute and plot ACF/PACF. Default is TRUE. / ACF/PACF anzeigen?}

\item{do_stl}{Logical. Whether to perform and plot STL decomposition. Default is TRUE. / STL-Dekomposition durchfuehren?}

\item{verbose}{Whether to print standardization info /Ob Statusinformationen ausgegeben werden sollen}

\item{max_lag_acf}{Max lag to use for ACF plots. Default is min(3 * frequency, floor(length(rate_diff_vec) / 4)). / Max. Verzoegerung fuer ACF}
}
\value{
A list containing:
\describe{
   \item{ts_data}{The cleaned numeric time series}
   \item{assessment}{Overall diagnostic and modeling recommendation}
   \item{adf}{ADF test result (stationarity)}
   \item{kpss}{KPSS test result (stationarity)}
   \item{plots}{Optional ggplot objects (e.g., time series plot)}
   \item{stationarity_assessment}{Summary of stationarity status and differencing recommendation}
}
}
\description{
This function performs diagnostics on a numeric time series (e.g., rate difference) to evaluate whether ARIMA modeling is appropriate.
It runs tests for autocorrelation (Ljung-Box), trend presence, and stationarity (ADF & KPSS), and gives modeling recommendations.
Optional visualizations include line plot, ACF/PACF, and STL decomposition.
}
\details{
Diese Funktion prueft, ob eine Zeitreihe (z.B. Differenz von Raten) fuer ARIMA-Modelle geeignet ist.
Sie fuehrt Autokorrelationspruefung (Ljung-Box), Trendtest, sowie Stationaritaetstests (ADF & KPSS) durch und gibt Modellierungsempfehlungen.
Optional werden Zeitreihengrafiken wie Linienplot, ACF/PACF und STL-Dekomposition erstellt.
}
\examples{
vec <- c(NA, rnorm(60, 0.1, 1))
check_rate_diff_arima_ready(vec, frequency = 12)

}
