% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_multi_group_tests.R
\encoding{UTF-8}
\name{run_multi_group_tests}
\alias{run_multi_group_tests}
\title{Multi-Group Test with Assumption Checks / Mehr-Gruppen-Test mit Annahmepruefung}
\usage{
run_multi_group_tests(
  df,
  value_col = ".value",
  group_col = "jahr",
  alpha = 0.05,
  effect_size = TRUE,
  report_assumptions = TRUE
)
}
\arguments{
\item{df}{A data frame with three or more groups. / Ein Data Frame mit drei oder mehr Gruppen}

\item{value_col}{Name of the column containing values to compare. Default is ".value". / Name der Werte-Spalte, Standard: ".value"}

\item{group_col}{Name of the grouping variable. Default is "jahr". / Spaltenname der Gruppierungsvariable, Standard: "jahr"}

\item{alpha}{Significance level for hypothesis testing. Default is 0.05. / Signifikanzniveau fuer Testentscheidungen, Standard: 0.05}

\item{effect_size}{Logical. Whether to calculate eta2 or its approximation. / Logisch, ob eta2 berechnet werden soll}

\item{report_assumptions}{Logical. Whether to include assumption checks. / Logisch, ob Vorannahmen ausgegeben werden sollen}
}
\value{
A list containing:
\describe{
  \item{type}{Type of test performed ("ANOVA" or "Kruskal-Wallis")}
  \item{sample_sizes}{Sample size per group}
  \item{assumptions}{List of assumption test results: Shapiro-Wilk, Levene, Bartlett}
  \item{anova / kruskal}{Test result object}
  \item{eta_squared / eta_squared_approx}{Effect size}
  \item{interpretation}{Interpretation of eta2 magnitude}
  \item{posthoc / dunn}{Post-hoc test result (Tukey or Dunn)}
  \item{recommendation}{Recommended method based on assumption checks}
}
}
\description{
This function performs multi-group statistical comparisons depending on distribution and variance assumptions.
If all groups pass the Shapiro-Wilk test for normality and Levene's test for homogeneity of variances, an ANOVA is performed with post-hoc Tukey test.
Otherwise, the Kruskal-Wallis test is used, followed by Dunn's test (Bonferroni-adjusted).
Effect size (eta2 or approximate) and assumption diagnostics are returned.
}
\details{
Diese Funktion fuehrt Mehr-Gruppen-Vergleiche durch, abhaengig von Verteilungs- und Varianzannahmen.
Wenn alle Gruppen normalverteilt sind (Shapiro-Wilk) und die Varianz homogen ist (Levene-Test), wird eine ANOVA mit Tukey-Post-Hoc-Test durchgefuehrt.
Andernfalls wird ein Kruskal-Wallis-Test mit anschliessender Dunn-Analyse (Bonferroni-korrigiert) verwendet.
Effektgroessen (eta2 oder Annaeherung) und Annahmepruefungen werden zurueckgegeben.
}
\examples{
df <- data.frame(
  jahr = rep(c("2020", "2021", "2022"), each = 10),
  .value = c(rnorm(10, 20), rnorm(10, 23), rnorm(10, 22))
)
run_multi_group_tests(df)

}
\seealso{
[run_group_tests()], [run_paired_tests()]
}
