% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_paired_tests.R
\encoding{UTF-8}
\name{run_paired_tests}
\alias{run_paired_tests}
\title{Paired / Unpaired Two-Group Tests with Assumption Checks / Zwei-Gruppen-Test mit Vorannahmepruefung}
\usage{
run_paired_tests(
  df,
  value_col = ".value",
  group_col = "jahr",
  alpha = 0.05,
  effect_size = TRUE,
  report_assumptions = TRUE,
  paired = TRUE
)
}
\arguments{
\item{df}{A data frame with exactly two groups. / Ein Data Frame mit genau zwei Gruppen}

\item{value_col}{Name of the column containing values to compare. Default is ".value". / Name der Werte-Spalte, Standard: ".value"}

\item{group_col}{Name of the grouping variable. Default is "jahr". / Spaltenname der Gruppierungsvariable, Standard: "jahr"}

\item{alpha}{Significance level for hypothesis testing. Default is 0.05. / Signifikanzniveau fuer Testentscheidungen, Standard: 0.05}

\item{effect_size}{Logical. Whether to calculate Cohen's d. / Logisch, ob Cohen's d berechnet werden soll}

\item{report_assumptions}{Logical. Whether to include normality test results. / Logisch, ob Shapiro-Test zurueckgegeben wird}

\item{paired}{Logical. Whether the data are paired. / Logisch: gepaarte Daten?}
}
\value{
A list containing:
\describe{
  \item{type}{Test type performed ("Paired Test" or "Unpaired Test")}
  \item{sample_sizes}{Number of observations per group}
  \item{group_names}{Names of the two groups}
  \item{t_test}{Result of the t-test (paired or unpaired)}
  \item{wilcox_test}{Result of the Wilcoxon test}
  \item{effect_size}{Cohen's d (if enabled)}
  \item{assumptions}{Shapiro-Wilk normality test result(s)}
  \item{recommendation}{Recommended test based on normality}
}
}
\description{
This function performs both parametric (t-test) and non-parametric (Wilcoxon test) comparisons between two groups.
For paired data, it calculates the difference and performs Shapiro-Wilk normality test on the difference. Based on this, it recommends either a paired t-test or a Wilcoxon signed-rank test.
Optionally, it calculates the effect size (Cohen's d) and returns assumption diagnostics.
}
\details{
Diese Funktion fuehrt sowohl parametrische (t-Test) als auch nicht-parametrische (Wilcoxon-Test) Vergleiche zwischen zwei Gruppen durch.
Bei gepaarten Daten wird die Differenz gebildet und auf Normalverteilung geprueft(Shapiro-Test). Je nach Ergebnis wird ein gepaarter t-Test oder ein Wilcoxon-Vorzeichen-Rang-Test empfohlen.
Optional wird die Effektgroesse (Cohens d) berechnet und die Vorannahmen zurueckgegeben.
}
\examples{
df <- data.frame(
  jahr = rep(c("2020", "2021"), each = 10),
  .value = c(rnorm(10, 30), rnorm(10, 32))
)
run_paired_tests(df, paired = TRUE)

}
\seealso{
[run_group_tests()], [run_multi_group_tests()], [prepare_group_data()]
}
