% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{GDRF.gecm.plot}
\alias{GDRF.gecm.plot}
\title{Evaluate (and possibly plot) the General Dynamic Treatment Effect (GDRF) for a Generalized Error Correction Model (GECM)}
\usage{
GDRF.gecm.plot(
  model = NULL,
  x.vrbl = NULL,
  y.vrbl = NULL,
  x.vrbl.d.x = NULL,
  y.vrbl.d.y = NULL,
  x.d.vrbl = NULL,
  y.d.vrbl = NULL,
  x.d.vrbl.d.x = NULL,
  y.d.vrbl.d.y = NULL,
  shock.history = "pulse",
  inferences.y = "levels",
  inferences.x = "levels",
  dM.level = 0.95,
  s.limit = 20,
  se.type = "const",
  return.data = FALSE,
  return.plot = TRUE,
  return.formulae = FALSE,
  ...
)
}
\arguments{
\item{model}{the \code{lm} model containing the GECM estimates}

\item{x.vrbl}{a named vector of the x variables (of the lower level of differencing, usually in levels d = 0) and corresponding lag orders in the GECM model}

\item{y.vrbl}{a named vector of the (lagged) y variables (of the lower level of differencing, usually in levels d = 0) and corresponding lag orders in the GECM model}

\item{x.vrbl.d.x}{the order of differencing of the x variable (of the lower level of differencing, usually in levels d = 0) in the GECM model}

\item{y.vrbl.d.y}{the order of differencing of the y variable (of the lower level of differencing, usually in levels d = 0) in the GECM model}

\item{x.d.vrbl}{a named vector of the x variables (of the higher level of differencing, usually first differences d = 1) and corresponding lag orders in the GECM model}

\item{y.d.vrbl}{a named vector of the y variables (of the higher level of differencing, usually first differences d = 1) and corresponding lag orders in the GECM model}

\item{x.d.vrbl.d.x}{the order of differencing of the x variable (of the higher level of differencing, usually first differences d = 1) in the GECM model}

\item{y.d.vrbl.d.y}{the order of differencing of the y variable (of the higher level of differencing, usually first differences d = 1) in the GECM model}

\item{shock.history}{the desired shock history. \code{shock.history} determines the shock history (h) that will be applied to the independent variable. -1 represents a pulse. 0 represents a step. These can also be specified via \code{pulse} and \code{step}. For others, see Vande Kamp, Jordan, and Rajan. The default is \code{pulse}}

\item{inferences.y}{does the user want resulting inferences about the dependent variable in levels or in differences? The default is \code{levels}}

\item{inferences.x}{does the user want to apply the shock history to the independent variable in levels or in differences? The default is \code{levels}}

\item{dM.level}{level of significance of the GDRF, calculated by the delta method. The default is 0.95}

\item{s.limit}{an integer for the number of periods to determine the GDRF (beginning at s = 0)}

\item{se.type}{the type of standard error to extract from the GECM model. The default is \code{const}, but any argument to \code{vcovHC} from the \code{sandwich} package is accepted}

\item{return.data}{return the raw calculated GDRFs as a list element under \code{estimates}. The default is \code{FALSE}}

\item{return.plot}{return the visualized GDRFs as a list element under \code{plot}. The default is \code{TRUE}}

\item{return.formulae}{return the formulae for the GDRFs as a list element under \code{formulae} (for the GDRFs) and \code{binomials} (for the shock history). The default is \code{FALSE}}

\item{...}{other arguments to be passed to the call to plot}
}
\value{
depending on \code{return.data}, \code{return.plot}, and \code{return.formulae}, a list of elements relating to the GDTE
}
\description{
Evaluate (and possibly plot) the General Dynamic Treatment Effect (GDRF) for a Generalized Error Correction Model (GECM)
}
\details{
We assume that the GECM model estimated is well specified, free of residual autocorrelation, balanced, and meets other standard time-series qualities. Given that, to obtain inferences for the specified shock history, the user only needs a named vector of the x and y variables, as well as the order of the differencing. Internally, the GECM to ADL equivalences are used to calculate the GDRFs from the GECM
}
\examples{
# GECM(1,1)
# Use the toy data to run a GECM. No argument is made this 
#  is well specified or even sensible; it is just expository
model <- lm(d_y ~ l_1_y + l_1_x + l_1_d_y + d_x + l_1_d_x, data = toy.ts.interaction.data)
test.pulse <- GDRF.gecm.plot(model = model,
                                  x.vrbl = c("l_1_x" = 1), 
                                  y.vrbl = c("l_1_y" = 1),
                                  x.vrbl.d.x = 0, 
                                  y.vrbl.d.y = 0,
                                  x.d.vrbl = c("d_x" = 0, "l_1_d_x" = 1),
                                  y.d.vrbl = c("l_1_d_y" = 1),
                                  x.d.vrbl.d.x = 1,
                                  y.d.vrbl.d.y = 1,
                                  shock.history = "pulse", 
                                  inferences.y = "levels", 
                                  inferences.x = "levels",
                                  s.limit = 10, 
                                  return.plot = TRUE, 
                                  return.formulae = TRUE)
names(test.pulse)
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{GDRF}
\keyword{GECM}
\keyword{plot}
