% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{extract_columns_with_table_source}
\alias{extract_columns_with_table_source}
\title{Extract columns with their source tables from a TWB}
\usage{
extract_columns_with_table_source(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\describe{
\item{datasource}{Datasource name.}
\item{name}{Raw column name (may include brackets/qualifiers).}
\item{caption}{Column caption if present.}
\item{datatype}{Tableau datatype.}
\item{role}{Tableau role.}
\item{semantic_role}{Semantic role if present.}
\item{table}{Raw table reference.}
\item{table_clean}{Cleaned table name (no brackets/suffix).}
\item{field_clean}{Cleaned field name.}
}
}
\description{
Scans top-level \verb{<datasource>} nodes (excluding view-specific references) and
returns fields with raw names/captions, cleaned table/field names, and basic
metadata.
}
\examples{

twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
fields <- extract_columns_with_table_source(xml)


}
