% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict,ubmsFit-method}
\alias{predict,ubmsFit-method}
\alias{predict}
\title{Predict parameter values from a fitted model}
\usage{
\S4method{predict}{ubmsFit}(
  object,
  submodel,
  newdata = NULL,
  transform = TRUE,
  re.form = NULL,
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{submodel}{Submodel to predict from, for example \code{"det"}}

\item{newdata}{Optional data frame, SpatRaster, or RasterStack of covariates to generate
predictions from. If not provided (the default), predictions are
generated from the original data}

\item{transform}{If \code{TRUE}, back-transform the predictions to their
original scale}

\item{re.form}{If \code{NULL}, any estimated group-level parameters ("random
effects") are included. If \code{NA}, they are ignored}

\item{level}{Probability mass to include in the uncertainty interval}

\item{...}{Currently ignored}
}
\value{
If \code{newdata} was a data frame: A data frame with one row per
  prediction and four columns:
  1) Predicted point estimates (posterior means),
  2) Standard deviation of the posterior,
  3-4) Lower and upper bounds of the specified uncertainty interval

  For parameters with more than one dimension, the rows are in site-major
  order, or site-year-observation for dynamic models.

  If \code{newdata} was a SpatRaster/RasterStack, returns a SpatRaster/RasterStack 
  with four layers corresponding to the four columns above with the same projection
  as the original SpatRaster/RasterStack.
}
\description{
This method generates predicted parameter values for the original dataset
or a new dataset using the posterior distribution. Standard deviation and
a customizable uncertainty interval are also calculated.
}
\seealso{
posterior_linpred, posterior_interval
}
