% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serial_interval.R
\docType{data}
\name{ganyani_clusters}
\alias{ganyani_clusters}
\title{COVID-19 cluster outbreaks data from Tianjin and Singapore}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 196 rows and 6 columns.
}
\source{
\url{https://github.com/cecilekremer/COVID19}
}
\usage{
data("ganyani_clusters")
}
\description{
Data from which serial interval and generation time estimates were performed
by Ganyani et al, 2020
}
\details{
Original article licensed under
\href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons 4.0}.
Data was cleansed and formatted for R.
\subsection{\code{ganyani_clusters} dataframe with 196 rows and 6 columns}{

\describe{
\item{ \code{id} (dbl) }{
a unique id for a person (unique within the \code{source})
}
\item{ \code{contacts} (list dbl) }{
list of known contacts in the cluster
}
\item{ \code{cluster_id} (dbl) }{
id of a cluster  (unique within the \code{source})
}
\item{ \code{symptom_onset} (date) }{
symptom onset date
}
\item{ \code{known_primary_case} (lgl) }{
flag if this person is know to be the primary case in the cluster
}
\item{ \code{source} (chr) }{
geographical source of the data
}
}
}
}
\examples{
dplyr::glimpse(ganyani_clusters)
}
\references{
Ganyani T, Kremer C, Chen D, Torneri A, Faes C, Wallinga J, Hens N.
Estimating the generation interval for coronavirus disease (COVID-19) based
on symptom onset data, March 2020. Euro Surveill. 2020 Apr;25(17):2000257.
doi: 10.2807/1560-7917.ES.2020.25.17.2000257. PMID: 32372755; PMCID:
PMC7201952.
}
\concept{datasets}
\keyword{datasets}
