% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/england_covid.R
\docType{data}
\name{ltla_cases}
\alias{ltla_cases}
\title{UK-wide COVID-19 case counts stratified by Lower tier local authority}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 512050 rows and 6 columns.
}
\source{
\url{https://ukhsa-dashboard.data.gov.uk/covid-19-archive-data-download}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("ltla_cases")
}
\description{
A dataset of the daily count of COVID-19 cases by Lower tier local authority
in the UK downloaded from the UKHSA coronavirus API, and formatted for
use in \code{ggoutbreak}.
}
\details{
\subsection{\code{ltla_cases} dataframe with 512050 rows and 6 columns}{

\describe{
\item{ \code{name} (chr) }{
The region name
}
\item{ \code{code} (chr) }{
The region code
}
\item{ \code{codeType} (chr) }{
The ONS geographical region code type (including year)
}
\item{ \code{date} (date) }{
The date
}
\item{ \code{count} (dbl) }{
the test positives for each LTLA
}
\item{ \code{population} (dbl) }{
the population size for this geography
}
}
}
}
\examples{
dplyr::glimpse(ltla_cases)
}
\concept{datasets}
\keyword{datasets}
