% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_formulas.R
\name{assign_formulas}
\alias{assign_formulas}
\title{Molecular Formula Assignment}
\usage{
assign_formulas(pl, formula_library, verbose = FALSE, ...)
}
\arguments{
\item{pl}{Either a peaklist (\code{data.table}) with at least columns \code{mz}, \code{i_magnitude},
and \code{file_id}, or a numeric vector of masses. For numeric input, a minimal
peaklist is constructed internally.}

\item{formula_library}{Molecular formula library: a predefined data.table used for
assigning molecular formulas to a peak list and for mass calibration. The library
requires a fixed format, including mass values for matching. Predefined libraries
are available in the R package \emph{ume.formulas} and further described in
Leefmann et al. (2019). A standard library for marine dissolved organic matter is
\code{ume.formulas::lib_02}. New libraries can be built using
\code{ume::create_ume_formula_library()}.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{
  Arguments passed on to \code{\link[=calc_ma_abs]{calc_ma_abs}}, \code{\link[=calc_neutral_mass]{calc_neutral_mass}}
  \describe{
    \item{\code{m}}{Measured mass}
    \item{\code{ma_dev}}{Mass accuracy in +/- parts per million (ppm)}
    \item{\code{mz}}{Numeric vector of m/z values (> 0).}
    \item{\code{pol}}{Character: \code{"neg"}, \code{"pos"}, or \code{"neutral"}.}
  }}
}
\value{
A \code{data.table} where each row represents a molecular formula assigned to a
mass peak. The table contains:

\itemize{
\item All columns of the input peaklist \code{pl} (e.g. \code{mz}, \code{i_magnitude}, \code{file_id}).
\item All columns of the input \code{formula_library} (e.g. \code{mf}, element counts).
\item Calculated columns:
\itemize{
\item \code{m} — neutral mass.
\item \code{m_cal} — exact mass of the assigned formula.
\item \code{del} — absolute mass error (Da).
\item \code{ppm} — mass error in parts per million.
\item \code{mf_id} — unique ID for each (file_id, mf) combination.
}
\item Added isotope columns (\verb{13C}, \verb{15N}, \verb{34S}) if missing in the library.
}

One peak may receive zero, one, or multiple assigned formulas depending on the
mass accuracy threshold.
}
\description{
Assigns molecular formulas to molecular masses using a predefined library.
Input of the peaklist (\code{pl}) is internally checked \code{\link[=as_peaklist]{as_peaklist()}},
converted to neutral masses \code{\link[=calc_neutral_mass]{calc_neutral_mass()}}, and assigned with
molecular formulas based on the mass accuracy (\code{ma_dev}) provided \code{\link[=calc_ma_abs]{calc_ma_abs()}}.
The input can be either:
\itemize{
\item A peaklist (\code{data.table}) containing m/z values or neutral masses
and additional metadata
.
\item A numeric vector of m/z values or neutral masses without additional metadata
(internally checked and standardized by \code{\link[=as_peaklist]{as_peaklist()}}).
}
}
\details{
This function calculates the neutral mass of peaks in \code{pl} and
compares it to mass values in \code{formula_library}, assigning molecular formulas
based on mass accuracy thresholds. If 13C, 15N, or 34S isotope information
is missing, additional columns are added to the output table.
}
\examples{
# Example using demo data
assign_formulas(pl = peaklist_demo,
                formula_library = ume::lib_demo,
                pol = "neg",
                ma_dev = 0.2,
                verbose = FALSE)
}
\author{
Boris P. Koch
}
