% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_isotope_info.R
\name{get_isotope_info}
\alias{get_isotope_info}
\title{Retrieve NIST element and isotope data}
\usage{
get_isotope_info(mfd, masses = ume::masses, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{masses}{A data.table. Defaults to \code{ume::masses} (based on NIST data)
containing isotope information for elements, including nominal and exact mass,
relative abundance, and Hill system order.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data.table containing information on all isotopes identified in mfd
and a column "orig_name" having the original names of the
isotope / element columns in \code{mfd}. Results are ordered according to Hill system.
}
\description{
Checks if element/isotope columns are present in \code{mfd}
and lookup of NIST isotope information (based on \link{masses}).
Can be applied to a formula library and any table having molecular formula data.
If only an element name is identified, the symbol and data of the lightest isotope
of the element will be returned.
For example, the column name "C" will return "12C" isotope data.
}
\examples{
get_isotope_info(mfd = mf_data_demo, verbose = TRUE)
}
\keyword{misc}
