% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ume_utilities.R
\name{ume_assign_formulas}
\alias{ume_assign_formulas}
\title{Complete formula assignment (wrapper function)}
\usage{
ume_assign_formulas(pl, formula_library, verbose = FALSE, ...)
}
\arguments{
\item{pl}{data.table containing peak data. Mandatory columns include neutral
molecular mass (\code{mass}), peak magnitude (\code{i_magnitude}), and a peak
identifier (\code{peak_id}).}

\item{formula_library}{Molecular formula library: a predefined data.table used for
assigning molecular formulas to a peak list and for mass calibration. The library
requires a fixed format, including mass values for matching. Predefined libraries
are available in the R package \emph{ume.formulas} and further described in
Leefmann et al. (2019). A standard library for marine dissolved organic matter is
\code{ume.formulas::lib_02}. New libraries can be built using
\code{ume::create_ume_formula_library()}.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{
  Arguments passed on to \code{\link[=calc_ma_abs]{calc_ma_abs}}, \code{\link[=calc_neutral_mass]{calc_neutral_mass}}, \code{\link[=assign_formulas]{assign_formulas}}, \code{\link[=eval_isotopes]{eval_isotopes}}, \code{\link[=calc_eval_params]{calc_eval_params}}, \code{\link[=add_known_mf]{add_known_mf}}, \code{\link[=calc_norm_int]{calc_norm_int}}
  \describe{
    \item{\code{m}}{Measured mass}
    \item{\code{ma_dev}}{Mass accuracy in +/- parts per million (ppm)}
    \item{\code{mz}}{Numeric vector of m/z values (> 0).}
    \item{\code{pol}}{Character: \code{"neg"}, \code{"pos"}, or \code{"neutral"}.}
    \item{\code{remove_isotopes}}{If set to TRUE (default), all entries for isotopologues are removed from mfd.
The main isotope information for each parent ion is still maintained in the "intxy"-columns.}
    \item{\code{mfd}}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}
    \item{\code{mf_col}}{Name of the column in mfd that has the molecular formula information (default: "mf").
Formulas have upper case element symbols and elements in the formula are ordered according to the Hill system.}
    \item{\code{known_mf}}{data.table with known molecular formulas (\code{ume::known_mf}).}
    \item{\code{ms_id}}{Character; name of the column identifying individual spectra (default: \code{"file_id"}).}
    \item{\code{peak_id}}{Character; name of the column identifying unique peaks (default: \code{"peak_id"}).}
    \item{\code{peak_magnitude}}{Character; name of the column containing peak intensity values (default: \code{"i_magnitude"}).}
    \item{\code{normalization}}{Character; normalization method to apply. One of \code{"bp"}, \code{"sum"}, \code{"sum_ubiq"}, \code{"sum_rank"}, \code{"none"}. Default is \code{"bp"}.}
    \item{\code{n_rank}}{Integer; number of top-ranked peaks to use for \code{"sum_rank"} normalization (default: 200).}
  }}
}
\value{
A data.table having molecular formula assignments for each mass.
}
\description{
Assigns molecular formulas to neutral molecular masses and calculates all parameters required for data evaluation, such as
a posteriori filtering of molecular formulas, plotting, and statistics.
The function uses a pre-build molecular formula library.
}
\details{
All function arguments:
args(filter_mf_data)
args(filter_int)
}
\examples{
ume_assign_formulas(pl = peaklist_demo, formula_library = lib_demo, pol = "neg", ma_dev = 0.2)
}
\seealso{
Other Formula assignment: 
\code{\link{add_known_mf}()},
\code{\link{calc_eval_params}()},
\code{\link{check_formula_library}()},
\code{\link{eval_isotopes}()}

Other Formula subsetting: 
\code{\link{filter_int}()},
\code{\link{filter_mass_accuracy}()},
\code{\link{filter_mf_data}()},
\code{\link{remove_blanks}()},
\code{\link{subset_known_mf}()},
\code{\link{ume_filter_formulas}()}

Other ume wrapper: 
\code{\link{ume_filter_formulas}()}
}
\concept{Formula assignment}
\concept{Formula subsetting}
\concept{ume wrapper}
\keyword{misc}
