% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_cvm.R
\name{uplot_cvm}
\alias{uplot_cvm}
\title{Plot of Molecular Mass (M) vs. Number of Carbon Atoms (C)}
\usage{
uplot_cvm(
  df,
  z_var = "co_tot",
  palname = "redblue",
  tf = FALSE,
  col_bar = TRUE,
  gg_size = 12,
  logo = TRUE,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.table containing columns:
\describe{
\item{\code{nm}}{Molecular mass (Da)}
\item{\verb{12C}}{Number of carbon atoms}
\item{\code{z_var}}{Variable used for color projection}
}}

\item{z_var}{Character. Column used for color mapping.}

\item{palname}{Character. Palette name passed to \code{f_colorz()}.}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
  }}
}
\value{
A ggplot2 or Plotly object.
}
\description{
Generates a scatter plot of \emph{molecular mass (M)} versus \emph{carbon atom count (C)},
color-coded by a selected variable (\code{z_var}).

This visualization follows the concept of the Carbon-vs-Mass (CvM) diagram
introduced by \strong{Reemtsma (2010)}.
}
\details{
Plot of Molecular Mass (M) vs. Number of Carbon Atoms (C)
}
\examples{
uplot_cvm(mf_data_demo, z_var = "co_tot", logo = FALSE)

}
\references{
Reemtsma, T. (2010).
\emph{The carbon versus mass diagram to visualize and exploit FTICR-MS data of natural organic matter.}
J. Mass Spectrom., \strong{45}, 382–390. \doi{10.1002/jms.1722}
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
