% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_dbe_minus_o_freq.R
\name{uplot_dbe_minus_o_freq}
\alias{uplot_dbe_minus_o_freq}
\title{Frequency Plot of DBE - O}
\usage{
uplot_dbe_minus_o_freq(df, gg_size = 12, logo = TRUE, plotly = FALSE, ...)
}
\arguments{
\item{df}{A data.table containing at least the column \code{dbe_o}.}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A ggplot2 object or, if requested, a Plotly object.
}
\description{
Creates a bar plot showing the frequency distribution of \code{dbe_o}
(DBE minus oxygen). The plot uses the unified UME plotting theme and
optionally adds a small UME caption. A Plotly version can be returned.
}
\examples{
uplot_dbe_minus_o_freq(mf_data_demo)

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
