% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_hc_vs_m.R
\name{uplot_hc_vs_m}
\alias{uplot_hc_vs_m}
\title{H/C vs Molecular Mass Plot}
\usage{
uplot_hc_vs_m(
  df,
  int_col = "norm_int",
  palname = "redblue",
  size_dots = 1.2,
  gg_size = 12,
  logo = TRUE,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A \code{data.table} containing columns:
\itemize{
\item \code{nm}: molecular mass
\item \code{hc}: hydrogen-to-carbon ratio
\item \code{int_col}: the column used for color-coding
}}

\item{int_col}{Character, column used for color-coding. Default \code{"norm_int"}.}

\item{palname}{Character, palette name passed to \code{f_colorz()}.}

\item{size_dots}{Numeric. Size of the dots in the plot (default = 0.5).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
    \item{\code{tf}}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}
  }}
}
\value{
A \code{ggplot2} scatter plot, or a \code{plotly} object if \code{plotly = TRUE}.
}
\description{
Creates a scatter plot of the hydrogen-to-carbon ratio (H/C) versus molecular
mass (\code{nm}). Points are color-coded according to a selected intensity or
property column (\code{int_col}). This visualization follows the conceptual design
in Schmitt-Kopplin et al. (2010).

The function can optionally add a branding label ("UltraMassExplorer") and can
optionally return an interactive Plotly version of the plot.
}
\examples{
uplot_hc_vs_m(mf_data_demo, int_col = "norm_int")

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
