% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_lcms.R
\name{uplot_lcms}
\alias{uplot_lcms}
\title{Plot LC-MS Spectrum (or fallback MS if no RT available)}
\usage{
uplot_lcms(
  pl,
  mass = "mz",
  peak_magnitude = "i_magnitude",
  retention_time = "ret_time_min",
  label = "file_id",
  logo = FALSE,
  ...
)
}
\arguments{
\item{pl}{data.table containing peak data. Mandatory columns include neutral
molecular mass (\code{mass}), peak magnitude (\code{i_magnitude}), and a peak
identifier (\code{peak_id}).}

\item{mass}{Column containing m/z values (default \code{"mz"}).}

\item{peak_magnitude}{Column containing intensity (default \code{"i_magnitude"}).}

\item{retention_time}{Column with retention time (default \code{"ret_time_min"}).}

\item{label}{Sample/group labeling column (default \code{"file_id"}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A plotly 3D visualization (LC-MS) or a 2D MS spectrum fallback.
}
\description{
Creates a 3D LC–MS plot (RT x m/z x intensity) \strong{when retention time is available}.
If no retention-time column exists (e.g., with DI-FTMS demo data), the function
gracefully falls back to \code{uplot_ms()} and issues an informative message.
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
