% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_ratios.R
\name{uplot_ratios}
\alias{uplot_ratios}
\title{Molecular Formula Ratio Plot (Sample vs Control)}
\usage{
uplot_ratios(
  df,
  upper = 90,
  lower = -90,
  grp = "file_id",
  int_col = "norm_int",
  control,
  sample,
  uniques = FALSE,
  conservative = FALSE,
  palname = "ratios",
  distrib = TRUE,
  main = NA,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.table containing at least columns:
\code{mf}, \code{oc}, \code{hc}, grouping variable \code{grp}, and intensity column \code{int_col}.}

\item{upper, lower}{Ratio filtering limits (default 90 / -90)}

\item{grp}{Column defining sample/control grouping}

\item{int_col}{Intensity column to use}

\item{control}{Character: control group name}

\item{sample}{Character: sample group name}

\item{uniques}{Logical: highlight uniquely present formulas}

\item{conservative}{Logical: stricter uniqueness definition}

\item{palname}{Color palette for projection}

\item{distrib}{Logical: include ratio distribution plot}

\item{main}{Optional main title}

\item{plotly}{Logical: convert output plots to plotly}

\item{...}{Additional arguments passed to methods.}
}
\value{
A list with:
\itemize{
\item \code{ratio_table}
\item \code{plot_ratio_vk}
\item \code{plot_ratio_distr}
}
}
\description{
Computes the intensity ratio between a sample and a control group and visualizes
it in a Van Krevelen diagram. Optionally highlights unique molecular formulas
and plots the ratio distribution.
}
\details{
Ratio Plot in Van Krevelen Space
}
\examples{
out <- uplot_ratios(
  df = mf_data_demo,
  grp = "file",
  control = "Nsea_a",
  sample  = "Fjord 01a"
)

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
