% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_reproducibility.R
\name{uplot_reproducibility}
\alias{uplot_reproducibility}
\title{Check Reproducibility of Sample Analyses}
\usage{
uplot_reproducibility(df, ri = "norm_int")
}
\arguments{
\item{df}{A data.table or data.frame containing at least columns \code{mf}
and the intensity column defined in \code{ri}.}

\item{ri}{Character string: name of the intensity column. Default: \code{"norm_int"}.}
}
\value{
A list containing:
\describe{
\item{\code{tmp}}{Summary table by molecular formula}
\item{\code{tmp2}}{Binned median RSD table}
\item{\code{plot_rsd}}{Scatter plot of RI vs RSD (ggplot2)}
\item{\code{plot_bins}}{Median RSD per bin (ggplot2)}
}
}
\description{
Computes reproducibility of sample analyses based on the relative intensity
column (\code{norm_int}). For each molecular formula (\code{mf}), the function calculates:
\itemize{
\item number of occurrences (\code{N})
\item median relative intensity (\code{ri})
\item relative standard deviation (RSD = sd/median × 100)
}

It also bins \code{ri} into integer bins and calculates the median RSD per bin.

The function returns:
\itemize{
\item processed tables
\item two \strong{ggplot2} objects:
\itemize{
\item intensity vs RSD scatter plot
\item binned median RSD plot
}
}
}
\examples{
out <- uplot_reproducibility(mf_data_demo, ri = "norm_int")
out$plot_rsd
out$plot_bins

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
