% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_counterexample}
\alias{simulate_counterexample}
\title{simulate counterexample data}
\usage{
simulate_counterexample(ntrain, ntest)
}
\arguments{
\item{ntrain}{number of training examples.}

\item{ntest}{number of test examples.}
}
\value{
a list with components "x", "y", "xtest", "ytest", "mutest", and "sigma", where "mutest" is the true test mean, and "ytest <- mutest + rnorm(ntest)*sigma."
}
\description{
A particular counterexample where the first two features are strongly positively correlated,
yet they have coefficients of opposite sign in a multiple regression.
}
\examples{
dat = simulate_counterexample(300,3000)
fit = cv.uniLasso(dat$x, dat$y)
err = mean( (predict(fit, dat$xtest,s="lambda.min")- dat$mutest)^2)
}
