% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniCoef.R
\name{uniCoef}
\alias{uniCoef}
\title{Compare the nonzero coefficients and univariate counterparts}
\usage{
uniCoef(cv.object, info = NULL, s = c("lambda.min", "lambda.1se"), ...)
}
\arguments{
\item{cv.object}{a \code{cv.uniLasso} or a \code{cv.glmnet} object.}

\item{info}{the result of a call to \code{uniInfo()}. If \code{cv.object} inherits from \code{cv.uniLasso}, the \verb{$info} component will be used.}

\item{s}{the value of lambda to be used, with default \code{s="lambda.min"}. Alternatively, can be `s="lambda.1se".}

\item{\ldots}{other arguments to \code{coef}.}
}
\value{
a three-columns data frame with the second column being the non-zero coefficients from the \code{cv.object}, the first the corresponding univariate coefficients, and the third an indication if there was a sign change.

@examples

sigma <- 3
set.seed(1)
n <- 100
p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)*sigma

cvfit <- cv.uniLasso(x, y)
uniCoef(cvfit)
cvfit2 <- cv.glmnet(x,y)
uniCoef(cvfit2, info=cvfit$info)
}
\description{
For a \code{cv.uniLasso} object, compare the CV-selected nonzero coefficients to their univariate counterparts. Also works for a \code{cv.glmnet} object.
}
