% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.r
\name{multiple.comma}
\alias{multiple.comma}
\title{multiple.comma}
\usage{
multiple.comma(x, digits = 0, ...)
}
\arguments{
\item{x}{Vector of numbers to be formatted.}

\item{digits}{Number of decimal places for rounding.}

\item{\dots}{Further arguments to be passed on to \code{\link{multiple}}}
}
\value{
Character vector of comma formatted numbers.
}
\description{
Order of Magnitude Formatter
}
\details{
Simply a wrapper for multiple that prespecifies the extra comma.
}
\examples{

library(scales)
vect <- c(1000, 1500, 23450, 21784, 875003780)
multiple.comma(vect)
multiple.comma(vect, multiple="k")
multiple.comma(vect, multiple="h")

library(ggplot2)
data(diamonds)
ggplot(diamonds, aes(x=x, y=y, color=price*100)) + geom_point() + 
scale_color_gradient2(labels=multiple.comma)

}
\author{
Jared P. Lander
}
