% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_access_utilities.R
\name{keep_by_label}
\alias{keep_by_label}
\title{Filter Teal Modules by Label}
\usage{
keep_by_label(x, label)
}
\arguments{
\item{x}{(\code{teal_module} or \code{teal_modules}) the object to filter.}

\item{label}{(\code{character(1)}) character vector of module labels to keep.}
}
\value{
Filtered \code{teal_modules} or \code{teal_module} object, or \code{NULL} if none matches.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Recursively filters a teal modules object to keep only modules whose labels
match the specified labels. Removes modules that don't match and empty
parent containers.
}
\examples{
# Keep only specific modules by label
mods <- teal::modules(
  teal::example_module("mod1"),
  teal::example_module("mod2")
)
filtered_mods <- keep_by_label(mods, c("Data Table", "Disposition"))

}
