#' valueprhr: Value-Price Analysis with Bayesian and Panel Data Methods
#'
#' This package provides tools for analyzing the relationship between
#' direct prices (based on labor values) and prices of production using
#' various econometric and statistical methods.
#'
#' @section Main Functions:
#' \describe{
#'   \item{\code{\link{prepare_panel_data}}}{Convert wide-format price matrices to panel data}
#'   \item{\code{\link{fit_bayesian_glm_sectors}}}{Fit Bayesian GLM for each sector}
#'   \item{\code{\link{fit_twoway_fe}}}{Fit two-way fixed effects panel model}
#'   \item{\code{\link{fit_mundlak_cre}}}{Fit Mundlak correlated random effects model}
#'   \item{\code{\link{fit_pls_multivariate}}}{Fit PLS regression with CV selection}
#'   \item{\code{\link{run_cca_var_analysis}}}{Run sparse CCA and panel VAR analysis}
#'   \item{\code{\link{rolling_window_cv}}}{Perform rolling window cross-validation}
#'   \item{\code{\link{test_structural_breaks}}}{Test for structural breaks}
#'   \item{\code{\link{compare_models}}}{Generate model comparison table}
#' }
#'
#' @docType package
#' @name valueprhr-package
#' @aliases valueprhr
#' @keywords internal
"_PACKAGE"
