% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian_glm.R
\name{extract_sector_coefficients}
\alias{extract_sector_coefficients}
\title{Extract Sector Coefficients}
\usage{
extract_sector_coefficients(sector_results)
}
\arguments{
\item{sector_results}{List of sector results from fit_bayesian_glm_sectors.}
}
\value{
Data frame with sector names, intercepts, and slopes.
}
\description{
Extracts intercepts and slopes from all sector models.
}
\examples{
\donttest{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  set.seed(123)
  years <- 2000:2010
  direct <- data.frame(
    Year = years,
    A = 100 + cumsum(rnorm(11)),
    B = 120 + cumsum(rnorm(11))
  )
  production <- data.frame(
    Year = years,
    A = 102 + cumsum(rnorm(11)),
    B = 118 + cumsum(rnorm(11))
  )
  results <- fit_bayesian_glm_sectors(direct, production,
                                       chains = 2, iter = 1000)
  coefs <- extract_sector_coefficients(results$results)
  print(coefs)
}
}

}
