% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca_pvar.R
\name{fit_aggregated_var}
\alias{fit_aggregated_var}
\title{Fit Aggregated VAR Model}
\usage{
fit_aggregated_var(panel_data, max_lags = 6L, difference = TRUE)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{max_lags}{Maximum lag order. Default 6.}

\item{difference}{Logical. Apply first differencing. Default TRUE.}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted vars::VAR model}
  \item{selected_lag}{Lag selected by information criteria}
  \item{irf}{Impulse response functions (if computed)}
  \item{fevd}{Forecast error variance decomposition (if computed)}
}
}
\description{
Fits a VAR model on time-aggregated (mean across sectors) data.
}
\examples{
\donttest{
if (requireNamespace("vars", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2019, 5),
    sector = rep(LETTERS[1:5], each = 20),
    log_direct = rnorm(100, 5, 0.5),
    log_production = rnorm(100, 5, 0.5)
  )

  result <- fit_aggregated_var(panel)
  print(result$selected_lag)
}
}

}
