% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_r2_values}
\alias{get_r2_values}
\title{Extract R-squared Values from rstanarm Model}
\usage{
get_r2_values(fit, verbose = FALSE)
}
\arguments{
\item{fit}{A fitted rstanarm model object.}

\item{verbose}{Logical. Print messages about extraction method. Default FALSE.}
}
\value{
A named numeric vector with mean, median, and mode R-squared values.
}
\description{
Attempts to extract R-squared using loo_R2, falling back to bayes_R2.
}
\examples{
\donttest{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  data(mtcars)
  fit <- rstanarm::stan_glm(mpg ~ wt, data = mtcars,
                            chains = 2, iter = 1000, refresh = 0)
  get_r2_values(fit)
}
}

}
