% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs}
\alias{v_specs}
\title{Specify configuration options for a \code{\link[=vchart]{vchart()}}.}
\usage{
v_specs(vc, ..., serie_id = NULL, drop_nulls = FALSE)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{List of options to specify for the chart, see \url{https://www.visactor.io/vchart/option/}.}

\item{serie_id}{Used to set or modify options for a chart where there are multiple series. You can use :
\itemize{
\item a \code{numeric} to target the position of the serie in the order where it's added to the chart
\item a \code{character} to refer to a \code{serie_id} set when the serie was added to the plot.
}}

\item{drop_nulls}{Drop NULL elements from the options.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Specify configuration options for a \code{\link[=vchart]{vchart()}}.
}
\examples{
library(vchartr)
data("mpg", package = "ggplot2")

vchart(table(Class = mpg$class)) \%>\%
  v_bar(aes(Class, Freq)) \%>\%
  v_specs(
    label = list(visible = TRUE),
    color = list("firebrick")
  )
}
