% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-diffs.R
\name{slice_diffs}
\alias{slice_diffs}
\title{Get rows with differing values}
\usage{
slice_diffs(comparison, table, column = everything())
}
\arguments{
\item{comparison}{The output of \code{compare()}}

\item{table}{A string matching one of the identifiers supplied via
\code{table_id} when calling \code{compare()} (defaults are \code{"a"} and
\code{"b"}). Within the comparison, these identifiers are stored in
\code{comparison$tables$table}.}

\item{column}{<\code{\link[=versus_tidy_select]{tidy-select}}>. A row will be in the output if
the comparison shows differing values for any columns matching this argument}
}
\value{
The input table is filtered to the rows for which \code{comparison}
shows differing values for one of the columns selected by \code{column}
}
\description{
Get rows with differing values
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
comp |> slice_diffs("a", mpg)
comp |> slice_diffs("b", mpg)
comp |> slice_diffs("a", c(mpg, disp))

comp <- compare(example_df_a, example_df_b, by = car, table_id = c("old", "new"))
comp |> slice_diffs("old", mpg)
}
