% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/famdcontourlabel.R
\name{famdcontourlabel}
\alias{famdcontourlabel}
\title{Outliers in Contour plots and FAMD function for classification modeling}
\usage{
famdcontourlabel(
  dataf = dataf,
  Idt = "",
  inf = 0.1,
  sup = 0.9,
  cutprob = 0.5,
  sizerepel = 3,
  ...
)
}
\arguments{
\item{dataf}{data frame.}

\item{Idt}{Identification variable, default "", row number}

\item{inf, sup}{Quantiles for x,y outliers}

\item{cutprob}{cut point for outliers based on prob.estimation error}

\item{sizerepel}{size for outliers label, default=3}

\item{...}{options to be passed from famdcontour}
}
\value{
A list with the following objects:\describe{
\item{graph1_graph6}{plots for dimension outliers}
\item{graph7_graph12}{plots for fit outliers}
}
}
\description{
This function adds outlier marks to famdcontour using ggrepel package.
}
\details{
An identification variable can be set in Idt parameter. By default, number of row is used.
There are two source of outliers: i) outliers in the two FAMD dimension space, where the cutpoints are set
as quantiles given (inf=0.1 and sup=0.9 in both dimensions by default) and ii) outliers with respect
to the fitted probability. The dependent variable is set to 1 for the minority class, and 0 for the majority class.
Points considered outliers are those for which abs(vardep-fittedprob) excede parameter cutprob.
\subsection{Troubleshooting}{
\itemize{
\item Check missings. Missing values are not allowed.
\item By default selec=0. Setting selec=1 may sometimes imply that no variables are selected; an error message is shown in this case.
\item Models with only two input variables could lead to plot generation problems.
\item Be sure that variables named in listconti are all numeric.
\item If some numeric variable is constant at one single value, process is stopped since numeric  Min-max standarization is performed,
and NaN values are generated.
\item Dependent variable can not be named x,y,z,x1,x2.
\item When there are only categorical variables as input use mcacontour instead
}
}
}
\examples{
data(breastwisconsin1)
dataf<-breastwisconsin1
listconti=c( "clump_thickness","uniformity_of_cell_shape","mitosis")
listclass=c("")
vardep="classes"
result<-famdcontourlabel(dataf=dataf,listconti=listconti,
listclass=listclass,vardep=vardep)
}
\keyword{FAMD}
\keyword{classification}
\keyword{contour_curves}
\keyword{outliers}
