# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Categorical Distribution
#'
#' Draw variates from a categorical distribution.
#'
#' @param n Number of desired draws.
#' @param p Vector of \eqn{k} probabilities for distribution.
#' @param log logical; if `TRUE`, interpret `p` as being specified on the
#' log-scale as `log(p)`. Otherwise, interpret `p` as being specified on the
#' original probability scale.
#' @param one_based logical; if `TRUE`, assume a categorical distribution
#' with support \eqn{\{ 1, \ldots, k \}}. Otherwise, assume support
#' \eqn{\{ 0, \ldots, k - 1 \}}.
#'
#' @return A vector of \eqn{n} draws.
#'
#' @examples
#' p = c(0.1, 0.2, 0.3, 0.4)
#' lp = log(p)
#'
#' set.seed(1234)
#' r_categ(50, p, log = FALSE, one_based = FALSE)
#' r_categ(50, p, log = FALSE, one_based = TRUE)
#'
#' set.seed(1234)
#' r_categ(50, lp, log = TRUE, one_based = FALSE)
#' r_categ(50, lp, log = TRUE, one_based = TRUE)
#'
#' @name Categorical
#' @export
r_categ <- function(n, p, log = FALSE, one_based = FALSE) {
    .Call(`_vws_r_categ_rcpp`, n, p, log, one_based)
}

#' Gumbel Distribution
#'
#' Functions for the Gumbel distribution with density
#' \deqn{
#' f(x \mid \mu, \sigma) =
#' \frac{1}{\sigma}
#' \exp\{ -\{ (x - \mu) / \sigma + e^{-(x - \mu) / \sigma} \} \}
#' }
#'
#' @param n Number of draws.
#' @param x Vector; argument of density.
#' @param p Vector; argument of cumulative distribution function.
#' @param q Vector; argument of quantile function.
#' @param mu Location parameter.
#' @param sigma Scale parameter.
#' @param lower Logical; if `TRUE` (default), probabilities are
#' \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.
#' @param log Logical; if `TRUE`, probabilities \eqn{p} are given as
#' \eqn{\log(p)}.
#'
#' @return
#' `d_gumbel` computes the density, `r_gumbel` generates random deviates,
#' `p_gumbel` computes the CDF, and `q_gumbel` computes quantiles. A vector is
#' returned by each.
#'
#' @examples
#' mu = 1
#' sigma = 2
#' x = r_gumbel(100000, mu, sigma)
#' xx = seq(min(x), max(x), length.out = 100)
#'
#' plot(density(x))
#' lines(xx, d_gumbel(xx, mu, sigma), lty = 2, col = "blue", lwd = 2)
#'
#' plot(ecdf(x))
#' lines(xx, p_gumbel(xx, mu, sigma), lty = 2, col = "blue", lwd = 2)
#'
#' pp = seq(0, 1, length.out = 102) |> head(-1) |> tail(-1)
#' qq = quantile(x, probs = pp)
#' plot(pp, qq)
#' lines(pp, q_gumbel(pp, mu, sigma), lty = 2, col = "blue", lwd = 2)
#'
#' @name Gumbel
#' @export
r_gumbel <- function(n, mu = 0, sigma = 1) {
    .Call(`_vws_r_gumbel_rcpp`, n, mu, sigma)
}

#' @name Gumbel
#' @export
d_gumbel <- function(x, mu = 0, sigma = 1, log = FALSE) {
    .Call(`_vws_d_gumbel_rcpp`, x, mu, sigma, log)
}

#' @name Gumbel
#' @export
p_gumbel <- function(q, mu = 0, sigma = 1, lower = TRUE, log = FALSE) {
    .Call(`_vws_p_gumbel_rcpp`, q, mu, sigma, lower, log)
}

#' @name Gumbel
#' @export
q_gumbel <- function(p, mu = 0, sigma = 1, lower = TRUE, log = FALSE) {
    .Call(`_vws_q_gumbel_rcpp`, p, mu, sigma, lower, log)
}

#' Log-Sum-Exp
#'
#' Compute arithmetic on the log-scale in a more stable way than directly
#' taking logarithm and exponentiating.
#'
#' @param x A numeric vector.
#' @param y A numeric vector; it should have the same length as `x`.
#'
#' @details
#' The function `log_sum_exp` computes `log(sum(exp(x)))` using the method in
#' StackExchange post \url{https://stats.stackexchange.com/a/381937}.
#'
#' The functions `log_add2_exp` and `log_sub2_exp` compute
#' `log(exp(x) + exp(y))` and `log(exp(x) - exp(y))`, respectively.
#' The function `log_sub2_exp` expects that each element of `x` is
#' larger than or equal to its corresponding element in `y`. Otherwise,
#' `NaN` will be returned with a warning.
#'
#' @return
#' `log_add2_exp` and `log_sub2_exp` return a vector of pointwise results
#' whose \eqn{i}th element is the result based on `x[i]` and `y[i]`.
#' `log_sum_exp` returns a single scalar.
#'
#' @examples
#' pi = 1:6 / sum(1:6)
#' x = log(2*pi)
#' log(sum(exp(x)))
#' log_sum_exp(x)
#'
#' # Result should be 0
#' x = c(-Inf -Inf, 0)
#' log_sum_exp(x)
#'
#' # Result should be -Inf
#' x = c(-Inf -Inf, -Inf)
#' log_sum_exp(x)
#'
#' # Result should be Inf
#' x = c(-Inf -Inf, Inf)
#' log_sum_exp(x)
#'
#' # Result should be 5 on the original scale
#' out = log_add2_exp(log(3), log(2))
#' exp(out)
#'
#' # Result should be 7 on the original scale
#' out = log_sub2_exp(log(12), log(5))
#' exp(out)
#'
#' @name log_sum_exp
#' @export
log_sum_exp <- function(x) {
    .Call(`_vws_log_sum_exp_rcpp`, x)
}

#' @name log_sum_exp
#' @export
log_add2_exp <- function(x, y) {
    .Call(`_vws_log_add2_exp_rcpp`, x, y)
}

#' @name log_sum_exp
#' @export
log_sub2_exp <- function(x, y) {
    .Call(`_vws_log_sub2_exp_rcpp`, x, y)
}

#' Hybrid Univariate Optimization
#'
#' Use Brent's method if a bounded search interval is specified. Otherwise use
#' BFGS method.
#'
#' @param f Objective function. Should take a scalar as an argument.
#' @param init Initial value for optimization variable.
#' @param lower Lower bound for search; may be \eqn{-\infty}.
#' @param upper Upper bound for search; may be \eqn{+\infty}.
#' @param maximize logical; if `TRUE`, optimization will be a maximization.
#' Otherwise, it will be a minimization.
#' @param maxiter Maximum number of iterations.
#'
#' @returns A list with the following elements.
#' \item{par}{Value of optimization variable.}
#' \item{value}{Value of optimization function.}
#' \item{method}{Description of result.}
#' \item{status}{Status code from BFGS or `0` otherwise.}
#'
#' @examples
#' f = function(x) { x^2 }
#' optimize_hybrid(f, init = 0, lower = -1, upper = 2, maximize = FALSE)
#' optimize_hybrid(f, init = 0, lower = -1, upper = Inf, maximize = FALSE)
#' optimize_hybrid(f, init = 0, lower = -Inf, upper = 1, maximize = FALSE)
#' optimize_hybrid(f, init = 0, lower = 0, upper = Inf, maximize = FALSE)
#' optimize_hybrid(f, init = 0, lower = -Inf, upper = 0, maximize = FALSE)
#'
#' f = function(x) { 1 - x^2 }
#' optimize_hybrid(f, init = 0, lower = -1, upper = 1, maximize = TRUE)
#' optimize_hybrid(f, init = 0, lower = -1, upper = 0, maximize = TRUE)
#' optimize_hybrid(f, init = 0, lower = 0, upper = 1, maximize = TRUE)
#'
#' @export
optimize_hybrid <- function(f, init, lower, upper, maximize = FALSE, maxiter = 10000L) {
    .Call(`_vws_optimize_hybrid_rcpp`, f, init, lower, upper, maximize, maxiter)
}

#' Rectangular transformation
#'
#' A transformation from unconstrained \eqn{\mathbb{R}^d} to a rectangle in
#' \eqn{\mathbb{R}^d}, and its inverse transformation.
#'
#' @param x A point in \eqn{\mathbb{R}^{d}}.
#' @param z A point in the rectangle \eqn{[a_1,b_1] \times \cdots \times [a_d,b_d]}.
#' @param a A vector \eqn{(a_1, \ldots, a_d)}, Elements may be `-Inf`.
#' @param b A vector \eqn{(b_1, \ldots, b_d)}, Elements may be `+Inf`.
#'
#' @return
#' A vector of length \eqn{d}.
#'
#' @examples
#' n = 20
#' x = seq(-5, 5, length.out = n)
#'
#' # Transform x to the interval [-1, 1]
#' a = rep(-1, n)
#' b = rep(+1, n)
#' z = inv_rect(x, a, b)
#' print(z)
#' xx = rect(z, a, b)
#' stopifnot(all(abs(x - xx) < 1e-8))
#'
#' # Transform x to the interval [-Inf, 1]
#' a = rep(-Inf, n)
#' b = rep(+1, n)
#' z = inv_rect(x, a, b)
#' print(z)
#' xx = rect(z, a, b)
#' stopifnot(all(abs(x - xx) < 1e-8))
#'
#' # Transform x to the interval [-1, Inf]
#' a = rep(-1, n)
#' b = rep(+Inf, n)
#' z = inv_rect(x, a, b)
#' print(z)
#' xx = rect(z, a, b)
#' stopifnot(all(abs(x - xx) < 1e-8))
#'
#' # Transform x to the interval [-Inf, Inf]
#' a = rep(-Inf, n)
#' b = rep(+Inf, n)
#' z = inv_rect(x, a, b)
#' print(z)
#' xx = rect(z, a, b)
#' stopifnot(all(abs(x - xx) < 1e-8))
#'
#' @name rect
#' @export
rect <- function(z, a, b) {
    .Call(`_vws_rect_rcpp`, z, a, b)
}

#' @name rect
#' @export
inv_rect <- function(x, a, b) {
    .Call(`_vws_inv_rect_rcpp`, x, a, b)
}

#' Produce a sequence of knots
#'
#' Produce knots which define \eqn{N} equally-spaced intervals between
#' (finite) endpoints `lo` and `hi`.
#'
#' @param lo Left endpoint; must be finite.
#' @param hi Right endpoint; must be finite.
#' @param N Number of desired intervals.
#' @param endpoints logical; if `TRUE`, include the endpoints.
#'
#' @returns
#' A vector that represents a sequence of knots. If `endpoints = TRUE`, it
#' contains \eqn{N+1} evenly-spaced knots that represent \eqn{N} regions with
#' endpoints included. If `endpoints = FALSE`, the endpoints are excluded.
#'
#' @examples
#' seq_knots(0, 1, N = 5)
#' seq_knots(0, 1, N = 5, endpoints = TRUE)
#'
#' # Trivial case: make endpoints for just one interval
#' seq_knots(0, 1, N = 1)
#' seq_knots(0, 1, N = 1, endpoints = TRUE)
#'
#' # The following calls throw errors
#' tryCatch({
#'   seq_knots(0, 1, N = 0)
#' }, error = function(e) { print(e) })
#' tryCatch({
#'   seq_knots(0, Inf, N = 5)
#' }, error = function(e) { print(e) })
#' tryCatch({
#'   seq_knots(-Inf, 1, N = 5)
#' }, error = function(e) { print(e) })
#'
#' @export
seq_knots <- function(lo, hi, N, endpoints = FALSE) {
    .Call(`_vws_rcpp_seq`, lo, hi, N, endpoints)
}

