% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_bandwidth.R
\name{kde_bandwidth}
\alias{kde_bandwidth}
\title{Robust bandwidth estimation for kernel density estimation}
\usage{
kde_bandwidth(data, method = c("robust", "normal", "plugin", "lookout"), ...)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{method}{A character string giving the method to use. Possibilities are:
\code{"normal"} (normal reference rule),
\code{"robust"} (a robust version of the normal reference rule, the default),
\code{"plugin"} (a plugin estimator), and
\code{"lookout"} (the bandwidth matrix estimate of Hyndman, Kandanaarachchi & Turner, 2026).}

\item{...}{Additional arguments are ignored unless \code{method = "lookout"}, when
they are passed to \code{\link[lookout:find_tda_bw]{lookout::find_tda_bw()}}.}
}
\value{
A matrix of bandwidths (or a scalar in the case of univariate data).
}
\description{
Bandwidth matrices are estimated using either a robust version of the normal
reference rule, or using the approach of Hyndman, Kandanaarachchi & Turner (2026).
}
\examples{
# Univariate bandwidth calculation
kde_bandwidth(oldfaithful$duration)
# Bivariate bandwidth calculation
kde_bandwidth(oldfaithful[, c("duration", "waiting")])
}
\references{
Rob J Hyndman, Sevvandi Kandanaarachchi & Katharine Turner (2026)
"When lookout sees crackle: Anomaly detection via kernel density estimation",
unpublished. \url{https://robjhyndman.com/publications/lookout2.html}

Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 2.7 and 3.9,
\url{https://OTexts.com/weird/}.
}
\author{
Rob J Hyndman
}
