% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfilling.R
\name{proxy_fill}
\alias{proxy_fill}
\title{Fill gaps using a proxy variable}
\usage{
proxy_fill(df, var, proxy_var, time_index, ...)
}
\arguments{
\item{df}{A tibble data frame containing one observation per row.}

\item{var}{The variable of df containing gaps to be filled.}

\item{proxy_var}{The variable to be used as proxy.}

\item{time_index}{The time index variable (usually year).}

\item{...}{Optionally, additional arguments that will be passed to
\code{linear_fill()} with the ratios. See that function to know the accepted
arguments.}
}
\value{
A tibble dataframe (ungrouped) where gaps in var have been filled,
a new proxy_ratio variable has been created,
and a new "source" variable has been created indicating if the value is
original or, in case it has been estimated, the gapfilling method that has
been used.
}
\description{
Fills gaps in a variable based on changes in a proxy variable, using ratios
between the filled variable and the proxy variable, and labels output
accordingly.
}
\examples{
sample_tibble <- tibble::tibble(
  category = c("a", "a", "a", "a", "a", "a", "b", "b", "b", "b", "b", "b"),
  year = c(
    "2015", "2016", "2017", "2018", "2019", "2020",
    "2015", "2016", "2017", "2018", "2019", "2020"
  ),
  value = c(NA, 3, NA, NA, 0, NA, 1, NA, NA, NA, 5, NA),
  proxy_variable = c(1, 2, 2, 2, 2, 2, 1, 2, 3, 4, 5, 6)
)
proxy_fill(sample_tibble, value, proxy_variable, year, .by = c("category"))
}
