% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_agriculture.R
\name{wbt_yield_filter}
\alias{wbt_yield_filter}
\title{Yield filter}
\usage{
wbt_yield_filter(
  input,
  yield_field,
  pass_field,
  output,
  width = 6.096,
  z_score_threshold = 2.5,
  min_yield = 0,
  max_yield = 99999.9,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input points shapefile.}

\item{yield_field}{Name of the attribute containing yield data.}

\item{pass_field}{Name of the attribute containing pass line ID.}

\item{output}{Name of the output points shapefile.}

\item{width}{Pass swath width (m).}

\item{z_score_threshold}{Z-score threshold value (default=2.5).}

\item{min_yield}{Minimum yield value in output.}

\item{max_yield}{Maximum yield value in output.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Filters crop yield values of point data derived from combine harvester yield monitors.
}
\keyword{PrecisionAgriculture}
