% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{catdv_vs_dvprobs}
\alias{catdv_vs_dvprobs}
\title{Non-simulation based likelihood model diagnostic}
\usage{
catdv_vs_dvprobs(
  xpdb,
  mapping = NULL,
  cutpoint = 1,
  type = "vbs",
  title = "@y vs. @x | @run",
  subtitle = "Ofv: @ofv, Number of individuals: @nind",
  caption = "@dir",
  tag = NULL,
  xlab = c("probability", "basic"),
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> or <\code{xpose_data}> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{cutpoint}{<\code{numeric}> Of defined probabilities, which one to
use in plots.}

\item{type}{See Details.}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{xlab}{Either use the typical basic x-axis label (the cutpoint-defined
column name) or label it based on the probability/likelihood it is estimating.}

\item{facets}{Additional facets}

\item{.problem}{Problem number}

\item{quiet}{Silence extra debugging output}

\item{...}{Any additional aesthetics.}
}
\value{
The desired plot
}
\description{
These plots attempt to provide a means of verifying that the
estimated likelihoods and probabilities for categorical outcomes
are captured within the model.

When the smooth spline is included (\code{type} includes \code{"s"}), it is
expected that the overall trend is up and to the right; a relatively
flat trend suggests that the modeled likelihood is inconsistent with the
observed outcome.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{b} box-whisker (using default quantiles)
\item \code{p} points (from \code{geom_dotplot})
\item \code{v} violin (from \code{geom_violin})
\item \code{o} outliers (show outliers)
\item \code{l} line through 0 (or as indicated in \code{hline_yintercept} or
\code{yline_xintercept})
\item \code{s} smooth line (from \code{geom_smooth})
\item \code{j} jitter points (from \code{geom_jitter})
\item \code{c} connecting lines for jitter points  (from \code{geom_path})
}
}
\examples{
# Test M3 model
pkpd_m3 \%>\%
  # Need to ensure var types are set
  set_var_types(catdv=BLQ,dvprobs=LIKE) \%>\%
  # Set probs
  set_dv_probs(1, 1~LIKE, .dv_var = BLQ) \%>\%
  # Optional, but useful to set levels
  set_var_levels(1, BLQ = lvl_bin()) \%>\%
  # Plot with basic xlab makes no assumptions
  catdv_vs_dvprobs(xlab = "basic")

# Test categorical model
vismo_xpdb <- vismo_pomod  \%>\%
  set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
  set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23)

# Various cutpoints (note axes labels and texts)
vismo_xpdb \%>\%
  catdv_vs_dvprobs(xlab = "basic")
vismo_xpdb \%>\%
  catdv_vs_dvprobs(cutpoint = 2, xlab = "basic")
vismo_xpdb \%>\%
  catdv_vs_dvprobs(cutpoint = 3, xlab = "basic")

# Latter is arguably clearer with default xlab
vismo_xpdb \%>\%
  catdv_vs_dvprobs(cutpoint = 3)

}
