% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xptr.R
\name{xptr}
\alias{xptr}
\title{Manipulating External Pointers}
\description{
There is limited native support for external pointers in the R interface.
This package provides some basic tools to verify, create and modify 'externalptr' objects.
}
\examples{
library(xptr)
a <- new_xptr("0x11a888090")
b <- new_xptr("0x11a888098")
is_xptr(a)
xptr_address(a)
xptr_clear(a)
is_null_xptr(a)
set_xptr_address(a, xptr_address(b))
xptr_address(a)
xptr_address(a, FALSE)
}
\references{
\url{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#External-pointers-and-weak-references}
}
\author{
Randy Lai and Dirk Eddelbuettel
}
